% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_peaklist.R
\name{validate_peaklist}
\alias{validate_peaklist}
\title{Validate UME peaklist structure}
\usage{
validate_peaklist(x)
}
\arguments{
\item{x}{A \code{data.table} representing a peaklist.}
}
\value{
The input \code{data.table} (invisibly) if validation passes.
}
\description{
Internal structural validator for UME peaklists.
Ensures that a peaklist has the correct columns, types,
and unique identifiers required for downstream processing
such as formula assignment.

Unlike \code{as_peaklist()}, this function does not modify the input
except for returning it unchanged if validation succeeds.
Instead, it raises informative errors that indicate what
structural issue was found.

This validator is called automatically inside \code{as_peaklist()}
and should not be used directly by end-users.
}
\details{
A valid UME peaklist must satisfy the following:
\subsection{Required columns}{

The following columns must exist:
\itemize{
\item \code{file_id} (integer)
\item \code{file}    (character; optional for minimal peaklists)
\item \code{peak_id} (integer)
\item \code{mz} (numeric, >= 0)
\item \code{i_magnitude} (numeric)
\item \code{s_n} (numeric; optional)
\item \code{res} (numeric; optional)
}

Missing optional columns are allowed if they are not explicitly
required for downstream operations.
}

\subsection{Type requirements}{
\itemize{
\item \code{file_id} and \code{peak_id} must be integer-like
\item \code{mz}, \code{i_magnitude}, \code{s_n}, \code{res} must be numeric
}
}

\subsection{Uniqueness}{

The pair \verb{(file_id, peak_id)} must be unique.
}
}
\keyword{internal}
