% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financial_functions.R
\name{fin_CAGR}
\alias{fin_CAGR}
\title{Calculate Compound Annual Growth Rate (CAGR)}
\usage{
fin_CAGR(beginningValue, endingValue, numYears, digits = 3)
}
\arguments{
\item{beginningValue}{Starting value of investment}

\item{endingValue}{Ending value of investment}

\item{numYears}{Number of periods (e.g., years) elapsing from begin to end}

\item{digits}{rounding the returned value (default = 3)}
}
\value{
A numeric value representing the Compound Annual Growth Rate as a 
  decimal (e.g., 0.096 for 9.6%).
}
\description{
Calculates the constant, period-over-period growth rate required for an
investment to grow from a beginning value to an ending value over a
specified number of periods.

The Compound Annual Growth Rate (CAGR) is computed as:
 CAGR = (End value/Start value)^(1/t) - 1

Where \emph{t} is the number of years (periods).
}
\note{
This function includes input validation and will `stop()` with an error
  if any inputs are non-numeric or non-positive.
}
\examples{
# --- Basic Usage ---
rate = fin_CAGR(beginningValue = 100, endingValue = 190, numYears = 7)
print(rate)

# --- Formatting as Percentage ---
percent = paste0(round(rate * 100, 2), "\%")
print(percent)

# --- Example with a Loss ---
fin_CAGR(100, 50, 5) 

\dontrun{
# --- Examples of what will fail ---
fin_CAGR(0, 100, 5)  # Error: Inputs must be positive
fin_CAGR(100, 150, -1) # Error: Inputs must be positive
fin_CAGR("100", 150, 5) # Error: All inputs must be numeric
}
}
