% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummary.MxModel}
\alias{umxSummary.MxModel}
\alias{umxSummary.MxRAMModel}
\title{Shows a compact, publication-style, summary of a RAM model}
\usage{
\method{umxSummary}{MxModel}(
  model,
  refModels = NULL,
  std = FALSE,
  digits = 2,
  report = c("markdown", "html"),
  means = TRUE,
  residuals = TRUE,
  SE = TRUE,
  filter = c("ALL", "NS", "SIG"),
  RMSEA_CI = FALSE,
  ...,
  matrixAddresses = FALSE
)
}
\arguments{
\item{model}{The \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} whose fit will be reported}

\item{refModels}{Saturated models if needed for fit indices (see example below:
If NULL will be computed on demand. If FALSE will not be computed.}

\item{std}{If TRUE, model is standardized (Default FALSE, NULL means "don't show").}

\item{digits}{How many decimal places to report (Default 2)}

\item{report}{If "html", then show results in browser (default = "markdown")}

\item{means}{Whether to include means in the summary (TRUE)}

\item{residuals}{Whether to include residuals in the summary (TRUE)}

\item{SE}{Whether to compute SEs... defaults to TRUE. In rare cases, you might need to turn off to avoid errors.}

\item{filter}{whether to show significant paths (SIG) or NS paths (NS) or all paths (ALL)}

\item{RMSEA_CI}{Whether to compute the CI on RMSEA (Defaults to FALSE)}

\item{...}{Other parameters to control model summary}

\item{matrixAddresses}{Whether to show "matrix address" columns (Default = FALSE)}
}
\value{
\itemize{
\item parameterTable returned invisibly, if estimates requested
}
}
\description{
Report the fit of a model in a compact form suitable for a journal.
It reports parameters in a markdown or html table (optionally standardized), and fit indices
RMSEA (an absolute fit index, comparing the model to a perfect model) and CFI and TLI (incremental fit indices comparing model a model with the worst fit).
}
\details{
\code{umxSummary} alerts you when model fit is worse than accepted criterion (TLI >= .95 and RMSEA <= .06; (Hu & Bentler, 1999; Yu, 2002).

Note: For some (multi-group) models, you will need to fall back on \code{\link[=summary]{summary()}}

\strong{CIs and Identification}
This function uses the standard errors reported by OpenMx to produce the CIs you see in umxSummary
These are used to derive confidence intervals based on the formula 95\%CI = estimate +/- 1.96*SE)

Sometimes SEs appear NA. This may reflect a model which is not identified (see \url{http://davidakenny.net/cm/identify.htm}).
This can include empirical under-identification - for instance two factors
that are essentially identical in structure. use \code{\link[OpenMx:mxCheckIdentification]{OpenMx::mxCheckIdentification()}} to check identification.

Solutions: If there are paths estimated at or close to zero suggests that fixing one or two of
these to zero may fix the standard error calculation.

If factor loadings can flip sign and provide identical fit, this creates another form of
under-identification and can break confidence interval estimation.
\emph{Solution}: Fixing a factor loading to 1 and estimating factor variances can help here.
}
\examples{
\dontrun{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
umxSummary(m1, std = TRUE)
# output as latex
umx_set_table_format("latex")
umxSummary(m1, std = TRUE)
umx_set_table_format("markdown")
# output as raw
umxSummary(m1, std = FALSE)

# switch to a raw data model
m1 = umxRAM("One Factor", data = demoOneFactor[1:100, ],
	umxPath("G", to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = "G")
)
umxSummary(m1, std = TRUE, filter = "NS")
}

}
\references{
\itemize{
\item Hu, L., & Bentler, P. M. (1999). Cutoff criteria for fit indexes in covariance
structure analysis: Conventional criteria versus new alternatives. \emph{Structural Equation Modeling}, \strong{6}, 1-55.
\item Yu, C.Y. (2002). Evaluating cutoff criteria of model fit indices for latent variable models
with binary and continuous outcomes. University of California, Los Angeles, Los Angeles.
Retrieved from \url{https://www.statmodel.com/download/Yudissertation.pdf}
}

\url{https://tbates.github.io}
}
\seealso{
\itemize{
\item \code{\link[=umxRAM]{umxRAM()}}
}

Other Summary functions: 
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummaryMRDoC}()}
}
\concept{Summary functions}
