% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_coverage.R
\name{coh_coverage}
\alias{coh_coverage}
\title{Calculate Vaccine Coverage}
\usage{
coh_coverage(
  data_set,
  vacc_date_col,
  unit = c("day", "month", "year"),
  date_interval = NULL
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine date to
calculate the coverage.}

\item{unit}{Aggregation unit, must be either "year", "month", or "day".}

\item{date_interval}{If NULL, the function calculates the coverage interval
based on the min() and max() of the \code{vacc_date_col}. It is also possible to
pass a custom date interval to truncate or expand the date interval (see
example).}
}
\value{
\code{data.frame} with the number of vaccine doses per date, cumulative
count of doses, and vaccine coverage.
}
\description{
This function returns the vaccination coverage of a dose along
the cohort study. The coverage can be calculated grouped by year, day, and
month. This must be specified in the parameter \code{unit}. If there are no
records for some dates, the function assigns 0 instead of NA to calculate
the cumulative coverage.
}
\keyword{internal}
