% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionset.R
\docType{class}
\name{expressionset-class}
\alias{expressionset-class}
\alias{expressionset}
\title{Superclass for storing a set of rich expressions.}
\description{
Superclass for storing a set of rich expressions.
}

\section{Details}{

This class is aimed at developers of this package or packages depending on
it, not at users. It is the parent object of both the \code{\link{validator}}
and the \code{\link{indicator}} class.


An \code{expressionset} is a reference class storing a list of
\code{\link{rule}}s. It contains a number of methods that are not exported
and may change or dissapear without notice. We strongly encourage developers
to use the exported S4 generics to set or extract variables
}

\section{Exported S4 methods for \code{expressionset}}{

\itemize{
 \item{\code{\link{variables}}}
 \item{\code{\link{names}}}
 \item{\code{\link{length,expressionset-method}}}
 \item{\code{\link{created}}}
 \item{\code{\link{origin}}}
 \item{\code{\link{labels}}}
 \item{\code{\link{description}}}
 \item{\code{\link{[,expressionset-method}}}
 \item{\code{\link{[[,expressionset-method}}}
 \item{\code{\link{summary,expressionset-method}}}
}
}

\section{Private S4 methods for \code{expressionset}}{

\itemize{
 \item{validating}
 \item{linear}
 \item{is_tran_assign}
}
}

\section{See also}{

\itemize{
 \item{\code{\link{rule}}}
 \item{\code{\link{validator}}}
 \item{\code{\link{indicator}}}
}
}

\keyword{internal}
