% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{indicator}
\alias{indicator}
\title{Define indicators for data}
\usage{
indicator(..., .file, .data)
}
\arguments{
\item{...}{A comma-separated list of indicator definitions}

\item{.file}{(optional) A character vector of file locations}
}
\description{
An indicator maps a data frame, or each record in a data frame to a number.
The purpose of this class is to store and apply expressions that define
indicators.
}
\examples{
# create an indicator for the number of missing x in data set


I <- indicator( 
 sum(is.na(.))               # number of missing variables
 , sum(is.na(.[c("x","y")])) # number of missing x and y
 , mean(is.na(.))            # fraction of missing variables
 , sum(x)
 , mean(x)
) 

dat <- data.frame(x=1:2, y=c(NA,1))
C <- confront(dat, I)
values(C)
}
\seealso{
\code{\link{syntax}}, \code{\link{add_indicators}}
}
\keyword{internal}
