% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Mobility}
\alias{Mobility}
\title{Social Mobility data}
\format{
A 2-dimensional array resulting from cross-tabulating 2 variables
for 19912 observations. The variable names and their levels are:

\tabular{rll}{
No \tab Name \tab Levels \cr
1\tab \verb{Son's_Occupation}\tab \verb{"UpNonMan", "LoNonMan", "UpManual", "LoManual", "Farm"}\cr
2\tab \verb{Father's_Occupation}\tab \verb{"UpNonMan", "LoNonMan", "UpManual", "LoManual", "Farm"}\cr
}
}
\source{
Falguerolles, A. de and Mathieu, J. R. (1988).  \emph{Proceedings of
COMPSTAT 88}, Copenhagen, Denmark, Springer-Verlag.

\% \cite{FeathermanHauser:78}

Featherman, D. L. and Hauser, R. M. Occupations and social mobility in the
United States.  \emph{Sociological Microjournal}, 12, Fiche 62. Copenhagen:
Sociological Institute.
}
\description{
Data on social mobility, recording the occupational category of fathers and
their sons.
}
\examples{

data(Mobility)
Mobility

# independence model
MASS::loglm(~Father_Occupation + Son_Occupation, data = Mobility)

vcd::mosaic(Mobility, shade=TRUE, legend = FALSE)



}
\seealso{
\code{\link{Glass}}, \code{\link{Hauser79}},
\code{\link{Yamaguchi87}} for other examples of mobility data.
}
\keyword{datasets}
