% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-plumber.R
\name{vetiver_write_plumber}
\alias{vetiver_write_plumber}
\title{Write a deployable Plumber file for a vetiver model}
\usage{
vetiver_write_plumber(
  board,
  name,
  version = NULL,
  ...,
  file = "plumber.R",
  rsconnect = TRUE,
  additional_pkgs = character(0)
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{...}{Other arguments passed to \code{\link[=vetiver_api]{vetiver_api()}} such as the endpoint
\code{path} or prediction \code{type}.}

\item{file}{A path to write the Plumber file. Defaults to \code{plumber.R} in the
working directory. See \code{\link[plumber:plumb]{plumber::plumb()}} for naming precedence rules.}

\item{rsconnect}{Create a Plumber file with features needed for \href{https://posit.co/products/enterprise/connect/}{Posit Connect}? Defaults to \code{TRUE}.}

\item{additional_pkgs}{Any additional R packages that need to be \strong{attached}
via \code{\link[=library]{library()}} to run your API, as a character vector.}
}
\value{
The content of the \code{plumber.R} file, invisibly.
}
\description{
Use \code{vetiver_write_plumber()} to create a \code{plumber.R} file for a
\code{\link[=vetiver_model]{vetiver_model()}} that has been versioned and stored via
\code{\link[=vetiver_pin_write]{vetiver_pin_write()}}.
}
\details{
By default, this function will find and use the latest version of your
vetiver model; the model API (when deployed) will be linked to that specific
version. You can override this default behavior by choosing a specific
\code{version}.
}
\examples{
\dontshow{if (rlang::is_installed("plumber")) withAutoprint(\{ # examplesIf}
library(pins)
tmp <- tempfile()
b <- board_temp(versioned = TRUE)
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

vetiver_write_plumber(b, "cars_linear", file = tmp)
\dontshow{\}) # examplesIf}
}
