% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_report.R
\name{ip_report}
\alias{ip_report}
\title{Get IP Address Report}
\usage{
ip_report(ip = NULL, ...)
}
\arguments{
\item{ip}{a valid IPv4 or IPv6 address; String; Required}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
list containing IP analysis results including geolocation,
ASN information, DNS resolutions, detected URLs, and threat intelligence
}
\description{
Retrieves comprehensive analysis report for an IP address, including
geolocation, ASN information, DNS resolutions, and detected URLs.
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')

ip_report(ip="8.8.8.8")
ip_report(ip="2001:4860:4860::8888")  # IPv6 example
}
}
\references{
\url{https://docs.virustotal.com/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
