% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_text}
\alias{whapi_send_text}
\title{Send a text message via Whapi.Cloud}
\usage{
whapi_send_text(
  to,
  body,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  quoted = NULL,
  edit = NULL,
  typing_time = NULL,
  no_link_preview = NULL,
  wide_link_preview = NULL,
  mentions = NULL,
  view_once = NULL,
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character. WhatsApp number in full international format WITHOUT "+"
(digits only, e.g. "5581999999999"), or an existing group/channel id.}

\item{body}{Character. Text of the message (UTF-8).}

\item{token}{Character. Whapi Bearer token. By default, taken from the
environment variable WHAPI_TOKEN if not provided.}

\item{quoted, edit}{Character (optional). Message IDs to quote or edit.}

\item{typing_time}{Numeric (optional). Seconds to simulate typing.}

\item{no_link_preview}{Logical (optional). TRUE to disable link preview.}

\item{wide_link_preview}{Logical (optional). TRUE to enable wide preview for links.}

\item{mentions}{Character vector (optional). Numbers to mention (without "+").}

\item{view_once}{Logical (optional). TRUE to mark message as "view once".}

\item{timeout}{Numeric. Request timeout in seconds. Default: 30.}

\item{verbose}{Logical. Print messages via cli? Default: TRUE.}
}
\value{
A tibble with essential information (id, to, status, timestamp) and
the full API response in column \code{resp} (as list).
}
\description{
Send a text message via Whapi.Cloud
}
\examples{
\dontrun{
# Make sure you set WHAPI_TOKEN in your environment or pass via argument
 Sys.setenv(WHAPI_TOKEN = "your_token_here")

# Simple example:
 whapi_send_text("5581999999999", "Hello! Test message via API")

# With extra options:
 whapi_send_text(
   to = "5581999999999",
   body = "Hello, @5581999999999 Ola",
   mentions = c("5581999999999"),
   typing_time = 2, no_link_preview = TRUE
 )
 }
}
