% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rw_to_wv}
\alias{rw_to_wv}
\title{Random Walk to WV}
\usage{
rw_to_wv(gamma2, tau)
}
\arguments{
\item{gamma2}{A \code{double} corresponding to variance of RW}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the random walk.
}
\description{
This function compute the WV (haar) of a Random Walk process
}
\section{Process Haar Wavelet Variance Formula}{

The Random Walk (RW) process has a Haar Wavelet Variance given by:
\deqn{\nu _j^2\left( {{\gamma ^2}} \right) = \frac{{\left( {\tau _j^2 + 2} \right){\gamma ^2}}}{{12{\tau _j}}} }{nu[j]^2 (gamma2) = ((tau[j]^2 + 2)*gamma2)/(12*tau[j])}
}

