% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_set.R
\name{reshape_set}
\alias{reshape_set}
\alias{unreshape_set}
\title{Convert xpose_set to a nested list.}
\usage{
reshape_set(x)

unreshape_set(y)
}
\arguments{
\item{x}{<\code{\link{xpose_set}}> An xpose_set object}

\item{y}{<\code{\link[tibble:tibble]{tibble}}> A nested table from an xpose_set}
}
\value{
<\code{\link[tibble:tibble]{tibble}}> Nested list, or <\code{\link{xpose_set}}>
}
\description{
This amounts to a convenience function for tidy manipulations.
}
\examples{

rset <- reshape_set(xpdb_set)
# Properties (exposed and top-level) can be seen. xpdb objects are nested in the xpdb column.
rset \%>\% dplyr::select(-xpdb) \%>\% dplyr::glimpse()

unreshape_set(rset)

# The reversibility of reshaping can be confirmed:
identical(xpdb_set,reshape_set(xpdb_set) \%>\% unreshape_set())

}
