% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{zenpath}
\alias{zenpath}
\title{Construct a Path of Indices to Order Variables}
\usage{
zenpath(x, pairs = NULL,
        method = c("front.loaded", "back.loaded",
                   "balanced", "eulerian.cross",
                   "greedy.weighted", "strictly.weighted"),
        decreasing = TRUE)
}
\arguments{
\item{x}{\describe{for \code{method}
    \describe{
        \item{\code{"front.loaded"}:}{single \code{\link{integer}} >= 1.}
        \item{\code{"back.loaded"}:}{as for \code{method = "front.loaded"}.}
        \item{\code{"balanced"}:}{as for \code{method = "front.loaded"}.}
        \item{\code{"eulerian.cross"}:}{two \code{\link{integer}}s >= 1
            representing the group sizes.}
        \item{\code{"greedy.weighted"}:}{\code{\link{numeric}} weight
            \code{\link{vector}} (or \code{\link{matrix}} or distance matrix).}
        \item{\code{"strictly.weighted"}:}{as for
            \code{method = "greedy.weighted"}.}
    }
}}

\item{pairs}{a two-column \code{\link{matrix}} containing (row-wise)
the pairs of connected variables to be sorted according to the
weights. Note that the resulting graph must be connected 
(i.e. any variable can be reached from any other variable 
following the connections given by \code{pairs}).
The \code{pairs} argument is only used for the \code{method}s
\code{greedy.weighted} and \code{strictly.weighted} and can be
\code{NULL} (in which case a default is constructed in lexicographical order).}

\item{method}{\code{\link{character}} string indicating the sorting
method to be used. Available methods are:
\describe{
       \item{\code{"front.loaded"}:}{Sort all pairs such that the first variables appear
                       the most frequently early in the sequence;
                       an Eulerian path; note that it might be slightly
                       longer than the number of pairs because, first, an even
                       graph has to be made.}
       \item{\code{"back.loaded"}:}{Sort all pairs such that the later variables appear
                      the most frequently later in the sequence;
                      an Eulerian path (+ see front.loaded concerning length)}
       \item{\code{"balanced"}:}{Sort all pairs such that all variables appear in
                   balanced blocks throughout the sequence
                   (a Hamiltonian Decomposition; Eulerian, too).}
       \item{\code{"eulerian.cross"}:}{Generate a sequence of pairs such that
                         each is formed with one variable from each group.}
       \item{\code{"greedy.weighted"}:}{Sort all pairs according to a greedy (heuristic)
                            Euler path with \code{x} as weights visiting each
                            edge precisely once.}
       \item{\code{"strictly.weighted"}:}{
        Strictly respect the order of the weights - so the first, second,
        third, and so on, adjacent pair of numbers of the output of
        \code{zenpath()} corresponds to the pair with largest,
        second-largest, third-largest, and so on, weight.
       }
       }}

\item{decreasing}{A \code{\link{logical}} indicating whether the
sorting is done according to increasing or decreasing weights.}
}
\value{
Returns a sequence of variables (indices or names,
possibly a list of such), which can then be used to index the data
(via \code{\link{groupData}()} for plotting via \code{\link{zenplot}()}.
}
\description{
Constructing zenpaths and tools for extracting,
connecting and displaying pairs, as well as
grouping and indexing data structures.
}
\details{
Most methods do not require any non-CRAN packages. However,
\code{method = "greedy.weighted"} constructs an Eulerian path via a
\code{\link[graph:graphNEL-class]{graphNEL}} object and therefore
requires Bioconductor package \pkg{graph} at runtime.
The \code{"strictly.weighted"} method does \emph{not} require \pkg{graph}.
}
\note{
For \code{method = "greedy.weighted"} only, \pkg{graph} must be installed.
If \pkg{graph} is unavailable, an informative error should be raised by the function.
}
\examples{
## Methods that do not need Bioconductor:
zenpath(5, method = "front.loaded")
zenpath(5, method = "balanced")

## Greedy weighted (requires Bioconductor 'graph' at runtime):
## Not run:
## if (requireNamespace("graph", quietly = TRUE)) {
##   w <- runif(choose(5, 2))
##   zp <- zenpath(w, method = "greedy.weighted")
## }
}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: 
\code{\link{connect_pairs}()},
\code{\link{extract_pairs}()},
\code{\link{graph_pairs}()},
\code{\link{groupData}()},
\code{\link{indexData}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
